/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.util.useradmin;

import filenet.vw.util.useradmin.MultiLogon;
import filenet.vw.util.useradmin.UserList;
import filenet.vw.util.useradmin.UserMod;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CommitList
extends JDialog
implements ListSelectionListener {
    private JList list;
    private DefaultListModel listModel;
    private DefaultListModel startModel;
    private boolean TestState = false;
    UserModRenderer renderer = new UserModRenderer();
    UserList modList = new UserList();
    MultiLogon modLogon = new MultiLogon();
    Object[][] data = new Object[1][4];
    private static final String commitString = "Commit";
    private static final String revertString = "Revert";
    private static final String commitAllString = "Commit All";
    private JButton RevertButton;
    private JButton CommitButton;
    private JButton CommitAllButton;
    private JButton ClearAllButton;
    private JButton CloseButton;
    private JTextField employeeName;

    public CommitList() {
        Object[][] data = new Object[][]{{"name", "email", "proxy", new Integer(1023)}};
        this.jbInit();
    }

    public CommitList(Object[][] ob) {
        this.jbInit();
    }

    public void setUserList(UserList ul, MultiLogon ml) {
        this.modList = ul;
        this.modLogon = ml;
    }

    void jbInit() {
        this.setTitle("User Modifications");
        this.setSize(400, 200);
        this.listModel = new DefaultListModel();
        if (this.TestState) {
            this.listModel.addElement(new UserMod("SuePervisor", "email", 1, 4, "", "spervisor@mail.com"));
            this.listModel.addElement(new UserMod("MoeMoney", "proxy", 2, 7, "SuePervisor", ""));
            this.listModel.addElement(new UserMod("WillSpend", "Flags", 3, 11, new Integer(0), new Integer(523)));
            this.listModel.addElement(new UserMod("MayCharge", "Flags", 3, 5, new Integer(333), new Integer(724)));
            this.list = new JList(this.listModel);
            this.list.setModel(this.listModel);
            this.list.setCellRenderer(this.renderer);
            this.list.setSelectionMode(0);
            this.list.setSelectedIndex(this.listModel.getSize() - 1);
            this.list.addListSelectionListener(this);
        } else {
            this.startModel = new DefaultListModel();
            this.list = new JList(this.startModel);
            this.list.setCellRenderer(null);
        }
        JScrollPane listScrollPane = new JScrollPane(this.list);
        JButton CommitButton = new JButton(commitString);
        CommitButton.setActionCommand(commitString);
        CommitButton.setMargin(new Insets(2, 2, 2, 2));
        CommitButton.addActionListener(new CommitListener());
        this.RevertButton = new JButton(revertString);
        this.RevertButton.setActionCommand(revertString);
        this.RevertButton.setMargin(new Insets(2, 2, 2, 2));
        this.RevertButton.addActionListener(new RevertListener());
        this.CommitAllButton = new JButton(commitAllString);
        this.CommitAllButton.setActionCommand(commitAllString);
        this.CommitAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.CommitAllButton.addActionListener(new CommitAllListener());
        this.ClearAllButton = new JButton("Clear All");
        this.ClearAllButton.addActionListener(new ClearAllListener());
        this.CloseButton = new JButton("Close");
        this.CloseButton.addActionListener(new CloseListener());
        JPanel buttonPane = new JPanel();
        this.ClearAllButton.setMargin(new Insets(2, 2, 2, 2));
        this.CloseButton.setMargin(new Insets(2, 2, 2, 2));
        buttonPane.add(CommitButton);
        buttonPane.add(this.RevertButton);
        buttonPane.add(this.CommitAllButton);
        buttonPane.add(this.ClearAllButton);
        buttonPane.add(this.CloseButton);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)listScrollPane, "Center");
        contentPane.add((Component)buttonPane, "North");
    }

    void showList() {
        if (this.list.getModel().equals(this.startModel)) {
            this.list.setModel(this.listModel);
            this.list.setCellRenderer(this.renderer);
            this.list.setSelectionMode(0);
            this.list.setSelectedIndex(this.listModel.getSize() - 1);
            this.list.addListSelectionListener(this);
        }
        this.show();
    }

    void hideList() {
        this.hide();
    }

    int getListSize() {
        return this.listModel.getSize();
    }

    void addMod(UserMod um) {
        this.listModel.addElement(um);
    }

    void setData(Object[][] ob) {
        this.data = ob;
    }

    MultiLogon getLocalLogon() {
        return this.modLogon;
    }

    public void valueChanged(ListSelectionEvent e) {
    }

    class UserModRenderer
    extends JLabel
    implements ListCellRenderer {
        private UserMod theUser;
        private String theMessage;

        public UserModRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.theUser = (UserMod)value;
            this.theMessage = this.theUser.UserName + ": " + this.theUser.Category + " from " + (this.theUser.OldValue == "" ? "null" : this.theUser.OldValue) + " to " + (this.theUser.NewValue == "" ? "null" : this.theUser.NewValue);
            this.setText(this.theMessage);
            return this;
        }
    }

    class CloseListener
    implements ActionListener {
        CloseListener() {
        }

        public void actionPerformed(ActionEvent e) {
            CommitList.this.hideList();
        }
    }

    class CommitAllListener
    implements ActionListener {
        private UserMod tempMod;

        CommitAllListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int size = CommitList.this.listModel.getSize();
            if (size > 0) {
                for (int i = size - 1; i >= 0; --i) {
                    this.tempMod = (UserMod)CommitList.this.listModel.get(i);
                    CommitList.this.modList.setUserProperty(this.tempMod.Category, this.tempMod.UserName, this.tempMod.NewValue);
                    CommitList.this.listModel.remove(i);
                }
            } else {
                System.out.println("nothing to commit");
            }
        }
    }

    class CommitListener
    implements ActionListener {
        private UserMod tempMod;

        CommitListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int size = CommitList.this.listModel.getSize();
            if (size > 0) {
                int index = CommitList.this.list.getSelectedIndex();
                this.tempMod = (UserMod)CommitList.this.listModel.get(index);
                CommitList.this.modList.setUserProperty(this.tempMod.Category, this.tempMod.UserName, this.tempMod.NewValue);
                CommitList.this.data[this.tempMod.row][this.tempMod.col] = this.tempMod.NewValue;
                CommitList.this.listModel.remove(index);
                if (index == CommitList.this.listModel.getSize()) {
                    --index;
                }
                CommitList.this.list.setSelectedIndex(index);
            } else {
                System.out.println("nothing to commit");
            }
        }
    }

    class ClearAllListener
    implements ActionListener {
        private UserMod tempMod;

        ClearAllListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int size = CommitList.this.listModel.getSize();
            if (size > 0) {
                for (int index = size - 1; index >= 0; --index) {
                    this.tempMod = (UserMod)CommitList.this.listModel.get(index);
                    System.out.println(this.tempMod.UserName + " reverting: " + this.tempMod.Category + " to " + (this.tempMod.OldValue.toString().length() == 0 ? "null" : this.tempMod.OldValue.toString()));
                    CommitList.this.data[this.tempMod.row][this.tempMod.col] = this.tempMod.OldValue;
                    CommitList.this.listModel.remove(index);
                }
            } else {
                System.out.println("nothing to clear");
            }
        }
    }

    class RevertListener
    implements ActionListener {
        private UserMod tempMod;

        RevertListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int size = CommitList.this.listModel.getSize();
            if (size > 0) {
                int index = CommitList.this.list.getSelectedIndex();
                this.tempMod = (UserMod)CommitList.this.listModel.get(index);
                System.out.println(this.tempMod.UserName + " reverting: " + this.tempMod.Category + " to " + (this.tempMod.OldValue.toString().length() == 0 ? "null" : this.tempMod.OldValue.toString()));
                CommitList.this.data[this.tempMod.row][this.tempMod.col] = this.tempMod.OldValue;
                CommitList.this.listModel.remove(index);
                if (index == CommitList.this.listModel.getSize()) {
                    --index;
                }
                CommitList.this.list.setSelectedIndex(index);
            } else {
                System.out.println("nothing to revert");
            }
        }
    }
}

